/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: SpaceEdit.h,v 1.1.1.1 1999/08/08 19:38:33 heller Exp $
____________________________________________________________________________*/

#ifndef Included_SpaceEdit_h	/* [ */
#define Included_SpaceEdit_h

// Format of the user defined callback
typedef VOID (*USERCALLBACK)(HWND,void *pUserValue);

PGP_BEGIN_C_DECLARATIONS

#if PRAGMA_IMPORT_SUPPORTED
#pragma import on
#endif

// SEInit
//
// Sets up a standard edit box for PGPstyle hide typing
// random spaces. UserCallback w/ pUserValue is called
// when a letter is typed into the edit box or the user
// presses the CAPSLOCK key. This way the application can
// update progress bars, caps warnings, min length etc.
VOID
SEInit(PGPContextRef context,HWND hwndEdit,
	   BOOL bHideTyping,USERCALLBACK UserCallback,
	   void *pUserValue);

// SEDestroy
//
// Please call this as it gets rid of the passphrase
// in memory (even though it is secalloced and XOR
// obsfucated
VOID 
SEDestroy(HWND hwndEdit);

// SEWipeEditBox
//
// Resets the edit box (like for a bad passphrase). 
VOID 
SEWipeEditBox (HWND hwndEdit);

// SEChangeHideTyping
//
// Switches from hidden typing to normal
VOID 
SEChangeHideTyping (HWND hwndEdit, BOOL bHideTyping);

// SEGetText
//
// Use this call instead of WM_GETTEXT
VOID 
SEGetText(HWND hwndEdit,char *copyto);

// SEGetTextLength
//
// Use this call instead of WM_GETTEXTLENGTH
DWORD
SEGetTextLength(HWND hwndEdit);

// SEGetTextQuality
//
// Usually used in conjunction with the user callback
DWORD
SEGetTextQuality(HWND hwndEdit);

// SEGetShowWarning
//
// Usually used in conjunction with the user callback
BOOL
SEGetShowWarning(HWND hwndEdit);

#if PRAGMA_IMPORT_SUPPORTED
#pragma import reset
#endif

PGP_END_C_DECLARATIONS

#endif /* ] Included_SpaceEdit_h */

/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/

